HEVC_SAMPLES_8BIT =             \
    AMP_A_Samsung_4             \
    AMP_A_Samsung_6             \
    AMP_B_Samsung_4             \
    AMP_B_Samsung_6             \
    AMP_D_Hisilicon             \
    AMP_E_Hisilicon             \
    AMP_F_Hisilicon_3           \
    AMVP_A_MTK_4                \
    AMVP_B_MTK_4                \
    AMVP_C_Samsung_4            \
    AMVP_C_Samsung_6            \
    BUMPING_A_ericsson_1        \
    CAINIT_A_SHARP_4            \
    CAINIT_B_SHARP_4            \
    CAINIT_C_SHARP_3            \
    CAINIT_D_SHARP_3            \
    CAINIT_E_SHARP_3            \
    CAINIT_F_SHARP_3            \
    CAINIT_G_SHARP_3            \
    CAINIT_H_SHARP_3            \
    CIP_A_Panasonic_3           \
    cip_B_NEC_3                 \
    CIP_C_Panasonic_2           \
    CONFWIN_A_Sony_1            \
    DBLK_A_SONY_3               \
    DBLK_B_SONY_3               \
    DBLK_C_SONY_3               \
    DBLK_D_VIXS_2               \
    DBLK_E_VIXS_2               \
    DBLK_F_VIXS_2               \
    DBLK_G_VIXS_2               \
    DELTAQP_A_BRCM_4            \
    DELTAQP_B_SONY_3            \
    DELTAQP_C_SONY_3            \
    DSLICE_A_HHI_5              \
    DSLICE_B_HHI_5              \
    DSLICE_C_HHI_5              \
    ENTP_A_Qualcomm_1           \
    ENTP_B_Qualcomm_1           \
    ENTP_C_Qualcomm_1           \
    EXT_A_ericsson_4            \
    FILLER_A_Sony_1             \
    HRD_A_Fujitsu_2             \
    HRD_A_Fujitsu_3             \
    INITQP_A_Sony_1             \
    ipcm_A_NEC_3                \
    ipcm_B_NEC_3                \
    ipcm_C_NEC_3                \
    ipcm_D_NEC_3                \
    ipcm_E_NEC_2                \
    IPRED_A_docomo_2            \
    IPRED_B_Nokia_3             \
    IPRED_C_Mitsubishi_3        \
    LS_A_Orange_2               \
    LS_B_ORANGE_4               \
    LTRPSPS_A_Qualcomm_1        \
    MAXBINS_A_TI_4              \
    MAXBINS_B_TI_4              \
    MAXBINS_C_TI_4              \
    MERGE_A_TI_3                \
    MERGE_B_TI_3                \
    MERGE_C_TI_3                \
    MERGE_D_TI_3                \
    MERGE_E_TI_3                \
    MERGE_F_MTK_4               \
    MERGE_G_HHI_4               \
    MVCLIP_A_qualcomm_3         \
    MVDL1ZERO_A_docomo_3        \
    MVEDGE_A_qualcomm_3         \
    NoOutPrior_A_Qualcomm_1     \
    NoOutPrior_B_Qualcomm_1     \
    NUT_A_ericsson_5            \
    OPFLAG_A_Qualcomm_1         \
    OPFLAG_B_Qualcomm_1         \
    OPFLAG_C_Qualcomm_1         \
    PICSIZE_A_Bossen_1          \
    PICSIZE_B_Bossen_1          \
    PICSIZE_C_Bossen_1          \
    PICSIZE_D_Bossen_1          \
    PMERGE_A_TI_3               \
    PMERGE_B_TI_3               \
    PMERGE_C_TI_3               \
    PMERGE_D_TI_3               \
    PMERGE_E_TI_3               \
    POC_A_Bossen_3              \
    PPS_A_qualcomm_7            \
    PS_A_VIDYO_3                \
    PS_B_VIDYO_3                \
    RAP_A_docomo_4              \
    RAP_B_Bossen_1              \
    RPLM_A_qualcomm_4           \
    RPLM_B_qualcomm_4           \
    RPS_A_docomo_4              \
    RPS_B_qualcomm_5            \
    RPS_C_ericsson_5            \
    RPS_D_ericsson_6            \
    RPS_E_qualcomm_5            \
    RPS_F_docomo_1              \
    RQT_A_HHI_4                 \
    RQT_B_HHI_4                 \
    RQT_C_HHI_4                 \
    RQT_D_HHI_4                 \
    RQT_E_HHI_4                 \
    RQT_F_HHI_4                 \
    RQT_G_HHI_4                 \
    SAO_A_MediaTek_4            \
    SAO_B_MediaTek_5            \
    SAO_C_Samsung_4             \
    SAO_C_Samsung_5             \
    SAO_D_Samsung_4             \
    SAO_D_Samsung_5             \
    SAO_E_Canon_4               \
    SAO_F_Canon_3               \
    SAO_G_Canon_3               \
    SDH_A_Orange_3              \
    SLICES_A_Rovi_3             \
    SLIST_A_Sony_4              \
    SLIST_B_Sony_8              \
    SLIST_C_Sony_3              \
    SLIST_D_Sony_9              \
    SLPPLP_A_VIDYO_1            \
    SLPPLP_A_VIDYO_2            \
    STRUCT_A_Samsung_5          \
    STRUCT_B_Samsung_4          \
    STRUCT_B_Samsung_6          \
    TILES_A_Cisco_2             \
    TILES_B_Cisco_1             \
    TMVP_A_MS_3                 \
    TSCL_A_VIDYO_5              \
    TSCL_B_VIDYO_4              \
    TSKIP_A_MS_3                \
    TUSIZE_A_Samsung_1          \
    VPSID_A_VIDYO_1             \
    VPSID_A_VIDYO_2             \
    WP_A_Toshiba_3              \
    WP_B_Toshiba_3              \
    WPP_A_ericsson_MAIN_2       \
    WPP_B_ericsson_MAIN_2       \
    WPP_C_ericsson_MAIN_2       \
    WPP_D_ericsson_MAIN_2       \
    WPP_E_ericsson_MAIN_2       \
    WPP_F_ericsson_MAIN_2       \
    WPP_HIGH_TP_444_8BIT_RExt_Apple_2 \

HEVC_SAMPLES_10BIT =            \
    DBLK_A_MAIN10_VIXS_3        \
    WP_A_MAIN10_Toshiba_3       \
    WP_MAIN10_B_Toshiba_3       \
    WPP_A_ericsson_MAIN10_2     \
    WPP_B_ericsson_MAIN10_2     \
    WPP_C_ericsson_MAIN10_2     \
    WPP_D_ericsson_MAIN10_2     \
    WPP_E_ericsson_MAIN10_2     \
    WPP_F_ericsson_MAIN10_2     \
    INITQP_B_Sony_1             \

HEVC_SAMPLES_422_10BIT =        \
    ADJUST_IPRED_ANGLE_A_RExt_Mitsubishi_1 \
    IPCM_A_RExt_NEC             \

HEVC_SAMPLES_422_10BIN_LARGE =  \
    Main_422_10_B_RExt_Sony_1   \

HEVC_SAMPLES_422_10BIN =        \
    Main_422_10_A_RExt_Sony_1   \
    $(if $(CONFIG_LARGE_TESTS), $(HEVC_SAMPLES_422_10BIN_LARGE))

HEVC_SAMPLES_444_8BIT =         \
    QMATRIX_A_RExt_Sony_1       \

HEVC_SAMPLES_444_12BIT_LARGE =  \
    SAO_A_RExt_MediaTek_1       \

HEVC_SAMPLES_444_12BIT =        \
    IPCM_B_RExt_NEC             \
    PERSIST_RPARAM_A_RExt_Sony_1\
    PERSIST_RPARAM_A_RExt_Sony_3\
    $(if $(CONFIG_LARGE_TESTS), $(HEVC_SAMPLES_444_12BIT_LARGE))

FATE_HEVC_VARS := 8BIT 10BIT 422_10BIT 422_10BIN 444_8BIT 444_12BIT
$(foreach VAR,$(FATE_HEVC_VARS), $(eval HEVC_TESTS_$(VAR) := $(addprefix fate-hevc-conformance-, $(HEVC_SAMPLES_$(VAR)))))

# equivalent bitstreams
# AMP_D_Hisilicon_3 -- AMP_D_Hisilicon
# AMP_E_Hisilicon_3 -- AMP_E_Hisilicon
# MVDL1ZERO_A_docomo_4 -- MVDL1ZERO_A_docomo_3
# RAP_A_docomo_5 -- RAP_A_docomo_4
# RAP_B_bossen_2 -- RAP_B_bossen_1
# RPS_A_docomo_5 -- RPS_A_docomo_4
# RPS_F_docomo_2 -- RPS_F_docomo_1

# do not pass:
# TSUNEQBD_A_MAIN10_Technicolor_2.bit (segfault mix 9-10bits)
# PERSIST_RPARAM_A_RExt_Sony_1 (rext)


$(HEVC_TESTS_8BIT): SCALE_OPTS := -pix_fmt yuv420p
$(HEVC_TESTS_444_8BIT): SCALE_OPTS := -pix_fmt yuv444p
$(HEVC_TESTS_10BIT): SCALE_OPTS := -pix_fmt yuv420p10le -vf scale
$(HEVC_TESTS_422_10BIT) $(HEVC_TESTS_422_10BIN): SCALE_OPTS := -pix_fmt yuv422p10le -vf scale
$(HEVC_TESTS_444_12BIT): SCALE_OPTS := -pix_fmt yuv444p12le -vf scale
fate-hevc-conformance-%: CMD = framecrc -flags unaligned -i $(TARGET_SAMPLES)/hevc-conformance/$(subst fate-hevc-conformance-,,$(@)).bit $(SCALE_OPTS)
$(HEVC_TESTS_422_10BIN): CMD = framecrc -flags unaligned -i $(TARGET_SAMPLES)/hevc-conformance/$(subst fate-hevc-conformance-,,$(@)).bin $(SCALE_OPTS)

FATE_HEVC-$(call FRAMECRC, HEVC, HEVC, HEVC_PARSER) += $(HEVC_TESTS_8BIT) $(HEVC_TESTS_444_8BIT)
FATE_HEVC-$(call FRAMECRC, HEVC, HEVC, HEVC_PARSER SCALE_FILTER) +=         \
                                                    $(HEVC_TESTS_10BIT)     \
                                                    $(HEVC_TESTS_422_10BIT) \
                                                    $(HEVC_TESTS_422_10BIN) \
                                                    $(HEVC_TESTS_444_12BIT) \

fate-hevc-paramchange-yuv420p-yuv420p10: CMD = framecrc -vsync passthrough -i $(TARGET_SAMPLES)/hevc/paramchange_yuv420p_yuv420p10.hevc -sws_flags area+accurate_rnd+bitexact
FATE_HEVC-$(call FRAMECRC, HEVC, HEVC, HEVC_PARSER SCALE_FILTER LARGE_TESTS) += fate-hevc-paramchange-yuv420p-yuv420p10

tests/data/hevc-mp4.mov: TAG = GEN
tests/data/hevc-mp4.mov: ffmpeg$(PROGSSUF)$(EXESUF) | tests/data
	$(M)$(TARGET_EXEC) $(TARGET_PATH)/$< -nostdin \
	-i $(TARGET_SAMPLES)/hevc-conformance/WPP_A_ericsson_MAIN10_2.bit -c copy -flags +bitexact $(TARGET_PATH)/$@ -y 2>/dev/null

FATE_HEVC-$(call ALLYES, HEVC_DEMUXER MOV_DEMUXER HEVC_PARSER HEVC_MP4TOANNEXB_BSF MOV_MUXER HEVC_MUXER) += fate-hevc-bsf-mp4toannexb
fate-hevc-bsf-mp4toannexb: tests/data/hevc-mp4.mov
fate-hevc-bsf-mp4toannexb: CMD = md5 -i $(TARGET_PATH)/tests/data/hevc-mp4.mov -c:v copy -fflags +bitexact -f hevc
fate-hevc-bsf-mp4toannexb: CMP = oneline
fate-hevc-bsf-mp4toannexb: REF = 1873662a3af1848c37e4eb25722c8df9

fate-hevc-skiploopfilter: CMD = framemd5 -skip_loop_filter nokey -i $(TARGET_SAMPLES)/hevc-conformance/SAO_D_Samsung_5.bit -sws_flags bitexact
FATE_HEVC-$(call FRAMEMD5, HEVC, HEVC, HEVC_PARSER) += fate-hevc-skiploopfilter

# this sample has two stsd entries and needs to reload extradata
FATE_HEVC-$(call FRAMEMD5, MOV, HEVC, SCALE_FILTER) += fate-hevc-extradata-reload
fate-hevc-extradata-reload: CMD = framemd5 -i $(TARGET_SAMPLES)/hevc/extradata-reload-multi-stsd.mov -sws_flags bitexact

fate-hevc-paired-fields: CMD = probeframes -show_entries frame=interlaced_frame,top_field_first $(TARGET_SAMPLES)/hevc/paired_fields.hevc
FATE_HEVC_FFPROBE-$(call DEMDEC, HEVC, HEVC) += fate-hevc-paired-fields

fate-hevc-monochrome-crop: CMD = probeframes -show_entries frame=width,height:stream=width,height $(TARGET_SAMPLES)/hevc/hevc-monochrome.hevc
FATE_HEVC_FFPROBE-$(call PARSERDEMDEC, HEVC, HEVC, HEVC) += fate-hevc-monochrome-crop

fate-hevc-hdr10-plus-metadata: CMD = probeframes -show_entries frame=side_data_list $(TARGET_SAMPLES)/hevc/hdr10_plus_h265_sample.hevc
FATE_HEVC_FFPROBE-$(call DEMDEC, HEVC, HEVC) += fate-hevc-hdr10-plus-metadata

fate-hevc-hdr-vivid-metadata: CMD = probeframes -show_entries frame=side_data_list $(TARGET_SAMPLES)/hevc/hdr_vivid_h265_sample.hevc
FATE_HEVC_FFPROBE-$(call PARSERDEMDEC, HEVC, HEVC, HEVC) += fate-hevc-hdr-vivid-metadata

fate-hevc-dv-rpu: CMD = probeframes -show_entries frame=side_data_list -select_streams 0 -read_intervals "%+\#2" $(TARGET_SAMPLES)/hevc/dv84.mov
FATE_HEVC_FFPROBE-$(call DEMDEC, MOV, HEVC) += fate-hevc-dv-rpu

fate-hevc-two-first-slice: CMD = threads=2 framemd5 -i $(TARGET_SAMPLES)/hevc/two_first_slice.mp4 -sws_flags bitexact -t 00:02.00 -an
FATE_HEVC-$(call FRAMEMD5, MOV, HEVC) += fate-hevc-two-first-slice

fate-hevc-cabac-tudepth: CMD = framecrc -flags unaligned -i $(TARGET_SAMPLES)/hevc/cbf_cr_cb_TUDepth_4_circle.h265 -pix_fmt yuv444p
FATE_HEVC-$(call FRAMECRC, HEVC, HEVC) += fate-hevc-cabac-tudepth

fate-hevc-small422chroma: CMD = framecrc -flags unaligned -i $(TARGET_SAMPLES)/hevc/food.hevc -pix_fmt yuv422p10le -vf scale
FATE_HEVC-$(call FRAMECRC, HEVC, HEVC, HEVC_PARSER SCALE_FILTER) += fate-hevc-small422chroma

FATE_SAMPLES_AVCONV += $(FATE_HEVC-yes)
FATE_SAMPLES_FFPROBE += $(FATE_HEVC_FFPROBE-yes)

fate-hevc: $(FATE_HEVC-yes) $(FATE_HEVC_FFPROBE-yes)
